#include <maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/toloka/matches/lib/include/feature.h>

#include <sstream>

namespace maps::mrc::eye {

FeatureById loadFeatures(pgpool3::Pool& pool, const FeatureIdPairs& pairs) {
    FeatureById featureById;

    db::TIds featureIds;
    for (const auto& pair : pairs) {
        featureIds.push_back(pair.first);
        featureIds.push_back(pair.second);
    }
    std::sort(featureIds.begin(), featureIds.end());
    featureIds.erase(std::unique(featureIds.begin(), featureIds.end()), featureIds.end());

    auto txn = pool.masterReadOnlyTransaction();
    auto features = db::FeatureGateway(*txn).loadByIds(featureIds);
    for (const auto& feature : features) {
        featureById.emplace(feature.id(), feature);
    }

    return featureById;
}

std::string makeFeatureUrl(db::TId featureId, common::ImageOrientation orientation) {
    static const std::string FEATURE_PREFIX = "https://core-nmaps-mrc-browser.maps.yandex.ru/feature/";
    static const std::string FEATURE_SUFFIX = "/image?orientation=";

    std::stringstream ss;
    ss << FEATURE_PREFIX
       << featureId
       << FEATURE_SUFFIX
       << static_cast<int>(orientation);

    return ss.str();
}

} // namespace maps::mrc::eye
