#include <maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/toloka/matches/lib/include/match.h>
#include <maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/toloka/matches/lib/include/strings.h>

#include <fstream>

namespace maps::mrc::eye {

MatchesByFeatureIdPair loadMatches(std::istream& input) {
    json::Value value = json::Value::fromStream(input);

    MatchesByFeatureIdPair matchesByFeatureIdPair;

    for (const auto& featurePairMatches : value[FIELD_FEATURES_PAIRS]) {
        db::TId featureId1 = featurePairMatches[FIELD_FEATURE_ID_1].as<db::TId>();
        db::TId featureId2 = featurePairMatches[FIELD_FEATURE_ID_2].as<db::TId>();
        FeatureIdPair pair(featureId1, featureId2);

        Matches matches;
        for (const auto& match : featurePairMatches[FIELD_MATCHES]) {
            db::TId objectId1 = match[FIELD_OBJECT_ID_1].as<db::TId>();
            db::TId objectId2 = match[FIELD_OBJECT_ID_2].as<db::TId>();

            matches.emplace_back(objectId1, objectId2);
        }

        matchesByFeatureIdPair[pair] = std::move(matches);
    }

    return matchesByFeatureIdPair;
}

MatchesByFeatureIdPair loadMatches(const std::string& path) {
    std::ifstream ifs(path);
    REQUIRE(ifs.is_open(), "Failed to open file: " << path);

    return loadMatches(ifs);
}

} // namespace maps::mrc::eye
