#include <maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/toloka/matches/lib/include/object.h>
#include <maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/toloka/matches/lib/include/strings.h>

namespace maps::mrc::eye {

Object Object::fromJson(const json::Value& value) {
    return {
        value[FIELD_OBJECT_ID].as<db::TId>(),
        value[FIELD_TYPE].as<std::string>(),
        common::ImageBox::fromJson(value[FIELD_BBOX]),
    };
}


ObjectsByFeatureId loadObjects(std::istream& input) {
    ObjectsByFeatureId objectsByFeatureId;

    const json::Value data = json::Value::fromStream(input);
    for (const json::Value& featureObjects : data[FIELD_FEATURES_OBJECTS]) {
        db::TId featureId = featureObjects[FIELD_FEATURE_ID].as<db::TId>();
        common::ImageOrientation orientation
            = common::ImageOrientation::fromExif(featureObjects[FIELD_ORIENTATION].as<int>());

        std::vector<Object> items;
        for (const json::Value& object : featureObjects[FIELD_OBJECTS]) {
            items.push_back(Object::fromJson(object));
        }

        objectsByFeatureId[featureId] = {orientation, std::move(items)};
    }
    return objectsByFeatureId;
}

ObjectsByFeatureId loadObjects(const std::string& path) {
    std::ifstream ifs(path);
    REQUIRE(ifs.is_open(), "Failed to open file: " << path);

    return loadObjects(ifs);
}

} // namespace maps::mrc::eye
