#include <maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/toloka/matches/lib/include/pair.h>

#include <fstream>

namespace maps::mrc::eye {

FeatureIdPairs loadPairs(std::istream& input) {
    FeatureIdPairs featureIdPairs;

    for (std::string line; std::getline(input, line); ) {
        if (line.empty()) {
            continue;
        }

        std::stringstream ss(line);
        db::TId featureId1;
        db::TId featureId2;
        ss >> featureId1 >> featureId2;
        featureIdPairs.emplace_back(featureId1, featureId2);
    }
    return featureIdPairs;
}

FeatureIdPairs loadPairs(const std::string& path) {
    std::ifstream ifs(path);
    REQUIRE(ifs.is_open(), "Feature to open file: " << path);

    return loadPairs(ifs);
}

} // namespace maps::mrc::eye
