#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/common/include/exif.h>
#include <maps/wikimap/mapspro/services/mrc/libs/common/include/image_box.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>

#include <maps/libs/json/include/value.h>

#include <vector>
#include <string>
#include <iostream>

namespace maps::mrc::eye {

struct Object {
    static Object fromJson(const json::Value& value);

    db::TId id;
    std::string type;
    common::ImageBox bbox;
};

struct Objects {
    common::ImageOrientation orientation;
    std::vector<Object> items;
};


using ObjectsByFeatureId = std::unordered_map<db::TId, Objects>;

ObjectsByFeatureId loadObjects(std::istream& input);

ObjectsByFeatureId loadObjects(const std::string& path);

} // namespace maps::mrc::eye
