#include <maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/toloka/matches/lib/tests/fixture.h>

#include <maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/toloka/matches/lib/include/feature.h>

namespace maps::mrc::eye::tests {

TEST_F(Fixture, load_features)
{
    const FeatureIdPairs pairs{
        {1, 2},
        {2, 3},
    };

    auto featureByFeatureId = loadFeatures(pool(), pairs);

    EXPECT_EQ(featureByFeatureId.size(), 3u);
    EXPECT_TRUE(featureByFeatureId.count(1));
    EXPECT_TRUE(featureByFeatureId.count(2));
    EXPECT_TRUE(featureByFeatureId.count(3));
}

TEST_F(Fixture, make_feature_url)
{
    std::string url = makeFeatureUrl(2u, common::ImageOrientation::fromExif(2));

    EXPECT_EQ(
        url,
        "https://core-nmaps-mrc-browser.maps.yandex.ru/feature/2/image?orientation=2"
    );
}

} // namespace maps::mrc::eye::tests
