#pragma once

#include <library/cpp/testing/gtest/gtest.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/unittest/include/yandex/maps/mrc/unittest/database_fixture.h>
#include <maps/wikimap/mapspro/services/mrc/libs/unittest/include/yandex/maps/mrc/unittest/local_server.h>
#include <maps/wikimap/mapspro/services/mrc/libs/unittest/include/yandex/maps/mrc/unittest/unittest_config.h>

namespace maps::mrc::eye::tests {

inline auto& playground() {
    static unittest::WithUnittestConfig<unittest::DatabaseFixture> global;
    return global;
}

struct Fixture: public testing::Test {
    Fixture() {
        constexpr common::Size size {1280, 720};

        features = {
            db::Feature{/* 0 */
                        "1",
                        geolib3::Point2{31, 10},
                        geolib3::Heading{12},
                        "2016-04-01 05:57:09+03",
                        mds::Key{unittest::MDS_GROUP_ID, "M1_CW0"},
                        db::Dataset::Agents},
            db::Feature{/* 1 */
                        "1",
                        geolib3::Point2{10, 50},
                        geolib3::Heading{90},
                        "2016-04-01 05:58:09+03",
                        mds::Key{unittest::MDS_GROUP_ID, "M1_CW0"},
                        db::Dataset::Agents},
            db::Feature{/* 2 */
                        "2",
                        geolib3::Point2{12, 87},
                        geolib3::Heading{67},
                        "2016-04-01 05:59:09+03",
                        mds::Key{unittest::MDS_GROUP_ID, "M1_CW0"},
                        db::Dataset::Agents},
            db::Feature{/* 3 */
                        "2",
                        geolib3::Point2{12, 87},
                        geolib3::Heading{67},
                        "2016-04-01 06:00:09+03",
                        mds::Key{unittest::MDS_GROUP_ID, "M1_CW0"},
                        db::Dataset::Agents},
        };

        for (auto&& feature : features) {
            feature
                .setOrientation(
                    common::ImageOrientation(common::Rotation::CW_0))
                .setSize(size)
                .setAutomaticShouldBePublished(true)
                .setIsPublished(true);
        }

        {
            auto txn =  newTxn();
            db::FeatureGateway(*txn).insert(features);
            txn->commit();
        }
    }

    ~Fixture() { playground().postgres().truncateTables(); }

    auto& pool() const { return playground().pool(); }

    maps::pgpool3::TransactionHandle newTxn() const {
        return pool().masterWriteableTransaction();
    }

    db::Features features;
};

} // namespace maps::mrc::eye::tests

