#include <library/cpp/testing/gtest/gtest.h>
#include <maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/toloka/matches/lib/include/match.h>
#include <maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/toloka/matches/lib/include/strings.h>

namespace maps::mrc::eye::tests {

TEST(match_tests, load_matches)
{
    std::string data = R"({
        "features_pairs": [
            {
                "feature_id_1": 1,
                "feature_id_2": 2,
                "matches": [
                    {
                        "object_id_1": 8,
                        "object_id_2": 1
                    }
                ]
            },
            {
                "feature_id_1": 2,
                "feature_id_2": 3,
                "matches": [
                    {
                        "object_id_1": 8,
                        "object_id_2": 8
                    }
                ]
            }
        ]
    })";

    std::istringstream input(data);

    MatchesByFeatureIdPair matchesByFeatureIdPair = loadMatches(input);

    EXPECT_EQ(matchesByFeatureIdPair.size(), 2u);

    FeatureIdPair pair1{1, 2};
    EXPECT_TRUE(matchesByFeatureIdPair.count(pair1));
    EXPECT_EQ(matchesByFeatureIdPair[pair1].size(), 1u);
    EXPECT_EQ(matchesByFeatureIdPair[pair1], Matches({{8, 1}}));

    FeatureIdPair pair2{2, 3};
    EXPECT_TRUE(matchesByFeatureIdPair.count(pair2));
    EXPECT_EQ(matchesByFeatureIdPair[pair2].size(), 1u);
    EXPECT_EQ(matchesByFeatureIdPair[pair2], Matches({{8, 8}}));
}

} // namespace maps::mrc::eye::tests
