#include <library/cpp/testing/gtest/gtest.h>
#include <maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/toloka/matches/lib/include/object.h>
#include <maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/toloka/matches/lib/include/strings.h>

namespace maps::mrc::eye::tests {

TEST(object_tests, object_from_json)
{
    std::string data = R"({
        "object_id" : 1,
        "type": "sign",
        "bbox": [[1, 2], [3, 4]]
    })";

    json::Value value = json::Value::fromString(data);

    Object object = Object::fromJson(value);

    EXPECT_EQ(object.id, 1u);
    EXPECT_EQ(object.type, "sign");
    EXPECT_EQ(object.bbox, common::ImageBox(1, 2, 3, 4));
}

TEST(object_tests, load_objects)
{
    std::string data = R"({
        "features_objects": [
            {
                "feature_id": 10,
                "orientation": 1,
                "objects": [
                    {
                        "type": "sign",
                        "bbox": [[1, 2], [3, 4]],
                        "object_id": 1
                    }
                ]
            }
        ]
    })";

    std::istringstream input(data);

    ObjectsByFeatureId objectsByFeatureId = loadObjects(input);

    EXPECT_EQ(objectsByFeatureId.size(), 1u);
    EXPECT_TRUE(objectsByFeatureId.count(10));

    const auto& objects = objectsByFeatureId.at(10);
    EXPECT_EQ(objects.items.size(), 1u);
    EXPECT_EQ(static_cast<int>(objects.orientation), 1);

    const auto& object = objects.items.at(0);
    EXPECT_EQ(object.id, 1u);
    EXPECT_EQ(object.type, "sign");
    EXPECT_EQ(object.bbox, common::ImageBox(1, 2, 3, 4));
}

} // namespace maps::mrc::eye::tests
