#include <library/cpp/testing/gtest/gtest.h>
#include <maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/toloka/matches/lib/include/pair.h>

namespace maps::mrc::eye::tests {

TEST(pair_tests, load_pairs)
{
    std::string data = "1 2\n3 4\n";

    std::istringstream input(data);

    FeatureIdPairs pairs = loadPairs(input);

    EXPECT_EQ(pairs.size(), 2u);
    EXPECT_EQ(pairs[0], FeatureIdPair(1, 2));
    EXPECT_EQ(pairs[1], FeatureIdPair(3, 4));
}

} // namespace maps::mrc::eye::tests
