#include <library/cpp/testing/gtest/gtest.h>
#include <maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/toloka/matches/lib/include/task.h>
#include <maps/wikimap/mapspro/services/mrc/eye/experiments/signs_map/toloka/matches/lib/tests/fixture.h>

namespace maps::mrc::eye::tests {

TEST_F(Fixture, create_task)
{
    const Objects objects1{
        common::ImageOrientation::fromExif(1),
        {{1, "sign1", common::ImageBox(1, 2, 3, 4)}}
    };
    const Objects objects2{
        common::ImageOrientation::fromExif(3),
        {{2, "sign2", common::ImageBox(2, 3, 4, 5)}}
    };

    Task task(
        features[1], objects1,
        features[2], objects2
    );

    EXPECT_EQ(task.feature1.id(), features[1].id());
    EXPECT_EQ(task.feature2.id(), features[2].id());
    EXPECT_EQ(task.objects1.items.size(), objects1.items.size());
    EXPECT_EQ(task.objects1.orientation, objects1.orientation);
    EXPECT_EQ(task.objects2.items.size(), objects2.items.size());
    EXPECT_EQ(task.objects2.orientation, objects2.orientation);
}

} // namespace maps::mrc::eye::tests
