def get_corrections(assignments):
    results_by_master_slave_id = {}
    for assignment in assignments:
        master_id = assignment['master_fdid']
        slave_id = assignment['slave_fdid']
        state = assignment['state']

        if master_id not in results_by_master_slave_id:
            results_by_master_slave_id[master_id] = {}

        if slave_id not in results_by_master_slave_id[master_id]:
            results_by_master_slave_id[master_id][slave_id] = []

        results_by_master_slave_id[master_id][slave_id].append(state)

    accepted, rejected = [], []
    for master_id, results_by_slave_id in results_by_master_slave_id.items():
        for slave_id, results in results_by_slave_id.items():
            yes_count = results.count('yes')
            no_count = results.count('no')
            if no_count > yes_count:
                rejected.append((master_id, slave_id))
            elif yes_count > no_count:
                accepted.append((master_id, slave_id))
    return accepted, rejected
