from feature import Size, Orientation, Rotation

class Box:
    def __init__(self, x1, y1, x2, y2):
        self.min_x = min(x1, x2)
        self.min_y = min(y1, y2)
        self.max_x = max(x1, x2)
        self.max_y = max(y1, y2)

    def area(self):
        return self.width() * self.height()

    def width(self):
        return self.max_x - self.min_x

    def height(self):
        return self.max_y - self.min_y

    def transform_by_orientation(self, orientation, original_image_size):
        assert not orientation.flip
        rotation = orientation.rotation
        box = self
        if rotation == Rotation.CW_90:
            box = self.rotate270cw(original_image_size)
        elif rotation == Rotation.CW_180:
            box = self.rotate180cw(original_image_size)
        elif rotation == Rotation.CW_270:
            box = self.rotate90cw(original_image_size)
        return box

    def rotate90cw(self, original_image_size):
        height = original_image_size.height
        return Box(height - self.max_y, self.min_x, height - self.min_y, self.max_x)

    def rotate180cw(self, original_image_size):
        width, height  = original_image_size.width, original_image_size.height
        return Box(width - self.max_x, height - self.max_y, width - self.min_x, height - self.min_y)

    def rotate270cw(self, original_image_size):
        width = original_image_size.width
        return Box(self.min_y, width - self.max_x, self.max_y, width - self.min_x)

class Detection:
    def __init__(self, detection_id, box, sign_type, orientation):
        self.detection_id = detection_id
        self.box = box
        self.sign_type = sign_type
        self.orientation = orientation
