from enum import IntEnum

class Point:
    def __init__(self, x, y):
        self.x = x
        self.y = y

class Rotation(IntEnum):
    CW_0 = 0
    CW_90 = 90
    CW_180 = 180
    CW_270 = 270
    CCW_0 = CW_0
    CCW_90 = CW_270
    CCW_180 = CW_180
    CCW_270 = CW_90


class Orientation:
    def __init__(self, flip, rotation):
        self.flip = flip
        self.rotation = rotation

    def to_exif(self):
        if self.flip:
            if self.rotation == Rotation.CW_0:
                return 2
            elif self.rotation == Rotation.CW_180:
                return 4
            elif self.rotation == Rotation.CW_90:
                return 5
            elif self.rotation == Rotation.CW_270:
                return 7
        else:
            if self.rotation == Rotation.CW_0:
                return 1
            elif self.rotation == Rotation.CW_180:
                return 3
            elif self.rotation == Rotation.CW_90:
                return 6
            elif self.rotation == Rotation.CW_270:
                return 8

    @staticmethod
    def from_exif(exif_value):
        return Orientation.values[exif_value]

    @staticmethod
    def default():
        return Orientation(False, Rotation.CW_0)

    def __repr__(self):
        return f'{self.flip}:{self.rotation}'


Orientation.values = {
    1: Orientation(False, Rotation.CW_0),
    2: Orientation(True, Rotation.CW_0),
    3: Orientation(False, Rotation.CW_180),
    4: Orientation(True, Rotation.CW_180),
    5: Orientation(True, Rotation.CW_90),
    6: Orientation(False, Rotation.CW_90),
    7: Orientation(True, Rotation.CW_270),
    8: Orientation(False, Rotation.CW_270),
}

class Size:
    def __init__(self, width, height):
        self.width = width
        self.height = height

class Feature:
    def __init__(self, data):
        self.feature_id = data['feature_id']
        self.width = data['width']
        self.height = data['height']

        self.pos = Point(data['pos']['x'], data['pos']['y'])
        self.heading = data['heading']

    def original_size(self):
        return Size(self.width, self.height)
