from feature import Feature, Orientation
from detection import Box, Detection

def generate_feature_url(feature, detection):
    url = 'https://core-nmaps-mrc-browser.maps.yandex.ru/feature/{}/image'.format(feature.feature_id)
    url = url + '?orientation={}'.format(detection.orientation.to_exif())
    return url

class Task:
    def __init__(self, detection1, feature1, detection2, feature2, state=None):
        self.feature_id1 = feature1.feature_id
        self.detection_id1 = detection1.detection_id
        self.image1 = generate_feature_url(feature1, detection1)
        box1 = detection1.box.transform_by_orientation(detection1.orientation, feature1.original_size())
        self.bbox1 = [[box1.min_x, box1.min_y], [box1.max_x, box1.max_y]]

        self.feature_id2 = feature2.feature_id
        self.detection_id2 = detection2.detection_id
        self.image2 = generate_feature_url(feature2, detection2)
        box2 = detection2.box.transform_by_orientation(detection2.orientation, feature2.original_size())
        self.bbox2 = [[box2.min_x, box2.min_y], [box2.max_x, box2.max_y]]

        self.state = state

    def to_json(self):
        input_values = {}

        input_values['feature_id1'] = self.feature_id1
        input_values['object_id1'] = self.detection_id1
        input_values['image1'] = self.image1
        input_values['bbox1'] = self.bbox1

        input_values['feature_id2']= self.feature_id2
        input_values['object_id2'] = self.detection_id2
        input_values['image2'] = self.image2
        input_values['bbox2'] = self.bbox2

        task = {'inputValues': input_values}

        if self.state is not None:
            known_solutions = [{'weight': 1, 'outputValues': {'state': self.state}}]
            task['knownSolutions'] = known_solutions

        return task
