Утилита для извлечения информации о дорожном графе (вершинах и рёбрах) и детектированных объектах
(дорожных знаках, связанных со скоростными ограничениями), и сохранения из в файл в формате json

Работаем по bounding box на карте, задаваемому широтой и долготой двух вершин.

Формат результирующего файла:

{
    "objects": [ # знаки дорожного движения
        {
            "id": 1940306,                  # id объекта в базе eye
            "heading": 0.34791467475734,    # направление нормали выходящей из знака (направление считается от Севера, по часовой стрелке)
            "position": [                   # позиция объекта в координатах меркатора
                4177878.9547311887,
                7478955.08375495
            ],
            "sign_type": "prescription_living_zone", # тип дорожного знака

            "edge_forward": true,           # это поле присутствует, если знак привязался к ребру,
                                            # если этот параметр true то, чтобы увидеть знак надо проходить ребро от from к to
            "edge_id": 2235318453,          # это поле присутствует, если знак привязался к ребру,
                                            # id ребра к которому привязался знак
            "edge_segment_idx": 0,          # это поле присутствует, если знак привязался к ребру,
                                            # индекс отрезка полилинии ребра, к которому привязался знак
            "slaves": [                     # список типов дополнительных табличек прилинкованных к знаку
                information_heavy_vehicle"
            ],
            "imageFeatures": [              # список изображений и ббоксов на них с детекциями данного объекта
                {
                    "id": 12345566,
                    "bbox": [1100, 100, 1200, 200],
                    "url": "https://core-nmaps-mrc-browser.maps.yandex.ru/feature/73129760/image?orientation=3"
                },
                ......
                {
                    "id": 53470094,
                    "bbox": [1168, 432, 1252, 520],
                    "url": "https://core-nmaps-mrc-browser.maps.yandex.ru/feature/73129760/image?orientation=3"
                }
            ]
        },
        ......
    ],


    "rd_el": [
        {
            "id": 2438189,                  # id ребра
            "commit_id": 232323232          # commit_id ребра
            "access_id": 61,                # тип дороги (пешеходная, автомобильная и т.п., мы сохраняем только автомобильные рёбра)
                                            # см. https://a.yandex-team.ru/arc/trunk/arcadia/maps/libs/ymapsdf/include/rd.h?rev=r8454359#L35
            "f_rd_jc_id": 2081794340,       # id вершины из которой выходит ребро
            "t_rd_jc_id": 1702139567,       # id вершины в которую заходит ребро
            "fc": 8,                        # функциональный класс участка дороги
            "oneway": 3,                    # флаг возможных направлений ребра (см. https://a.yandex-team.ru/arc/trunk/arcadia/maps/libs/ymapsdf/include/rd.h?rev=r8454359#L104)
            "points": [                     # точки задающие полилинию ребра (меркатор)
                [
                    4177917.1638381155,
                    7478943.456176281
                ],
                [
                    4177910.565623031,
                    7478946.007441152
                ],
                [
                    4177884.2793397163,
                    7478958.709133709
                ]
            ],
            "sign_ids_f": [],               # список id знаков привязанных к ребру проезжаемому в прямом направлении
            "sign_ids_t": [],               # список id знаков привязанных к ребру проезжаемому в прямом направлении
            "speed_limit_f": 20,            # скоростное ограничения на ребре в прямом направлении
            "speed_limit_t": 20,            # скоростное ограничения на ребре в обратном направлении
            "speed_limit_truck_f": 20,      # скоростное ограничения для грузовиков на ребре в прямом направлении
            "speed_limit_truck_t": 20,      # скоростное ограничения для грузовиков на ребре в обратном направлении

            "f_zlev": -2,                   # уровень начальной вершины ребра (-2, -1, 0, 1, 2)
            "t_zlev": -2,                   # уровень конечной вершины ребра (-2, -1, 0, 1, 2)
        },
        .......
    ],

    "rd_jc": [
        {
            "id": 2438187,                  # id вершины
            "point": [                      # координаты вершины (меркатор)
                4177869.7442424223,
                7478965.732581448
            ]
        },
        ......
    ],

    "cond": [
        {
            "access_id": 46,                # тип дороги (пешеходная, автомобильная и т.п., мы сохраняем только автомобильные рёбра)
                                            # см. https://a.yandex-team.ru/arc/trunk/arcadia/maps/libs/ymapsdf/include/rd.h?rev=r8454359#L35
            "id": 1691854227,               # id условия
            "commit_id": 24742769,          # commit_id условия
            "cond_type": 5,                 # тип условия, лучше всего читать в https://doc.yandex-team.ru/ymaps/ymapsdf/ymapsdf-ref/concepts/road_cond.html
                                            # см. https://a.yandex-team.ru/arc/trunk/arcadia/maps/libs/ymapsdf/include/rd.h?rev=r8162694#L144
            "from_edge": 1691854128,        # начальное ребро манёвра
            "via_node": 1691854127,         # вершина через которую идёт манёвр (к которой привязано условие)
            "to_edges": [                   # упорядоченный список рёбер по которым идёт манёвр после начального ребра
                1560585969
            ],
        }
    ],

}