import argparse
import maps.wikimap.mapspro.services.mrc.eye.experiments.speed_limits.pylibs.road_graph_utils as rg_utils
from maps.wikimap.mapspro.services.mrc.eye.experiments.speed_limits.make_speed_limits.speed_limits_markup import make_speed_limits_by_fc, make_speed_limits_by_objects


def main():
    parser = argparse.ArgumentParser(description="Make speed limits markup")

    parser.add_argument('--road-graph', required=True,
                        help='Path to input json file with road graph')
    parser.add_argument('--result-graph', default=None,
                        help='Path to output json file with speed limits')
    parser.add_argument('--markup-type', required=True, choices=["by_fc", "by_objects"],
                        help='Type of speed limits markup algorithm ("by_fc", "by_objects")')
    parser.add_argument('--filter-min-fc', default=None, type=int,
                        help='Remove edges with FC great or equal than this value (default: None)')
    parser.add_argument('--filter-min-speed', default=None, type=int,
                        help='Remove objects with speed limits signs less than this value (default: None)')
    parser.add_argument('--filter-min-date', default=None,
                        help='Remove objects with date less than this value (default: None)')

    args = parser.parse_args()
    nodes, edges, objects, _ = rg_utils.load_road_graph(args.road_graph)

    if args.filter_min_fc is not None:
        edges = rg_utils.filter_edges_by_fc(edges, args.filter_min_fc)
        objects = rg_utils.remove_objects_wo_edges(objects, edges)

    if args.filter_min_speed is not None:
        small_speeds = ["prohibitory_max_speed_" + str(i) for i in range(5, args.filter_min_speed, 5)]
        objects = rg_utils.remove_objects_by_types(objects, small_speeds)

    if args.filter_min_date is not None:
        date = rg_utils.convertSQLDateTimeToTimestamp(args.filter_min_date)
        objects = rg_utils.remove_objects_by_date(objects, date)

    edges = rg_utils.rest_only_valid_signs_at_edge(edges, [obj["id"] for obj in objects])

    if args.markup_type == "by_fc":
        edges = make_speed_limits_by_fc(edges)
    elif args.markup_type == "by_objects":
        edges = make_speed_limits_by_objects(edges, objects)
    rg_utils.save_road_graph(nodes, edges, objects, args.result_graph)


if __name__ == '__main__':
    main()
