#pragma once

#include <maps/wikimap/mapspro/services/mrc/eye/lib/common/include/load.h>
#include <maps/wikimap/mapspro/services/mrc/libs/yt/include/common.h>
#include <maps/wikimap/mapspro/libs/revision/include/yandex/maps/wiki/revision/common.h>
#include <maps/libs/pgpool/include/pgpool3.h>


#include <mapreduce/yt/interface/client.h>

#include <optional>
#include <string>

namespace maps::mrc::eye {

struct MrcWorkerConfig {
    pgpool3::Pool* pool{nullptr};

    bool commit{false};
    bool lockFree{false};
};

bool isValid(const MrcWorkerConfig& config);


struct YtWorkerConfig {
    NYT::IClientBase* client{nullptr};
    const FrameLoader* frameLoader{nullptr};

    bool commit{false};
    std::string rootPath{"//tmp"};
    size_t partitionSize{0};
    size_t concurrency{0};
    bool useGpu{false};
    std::optional<std::string> portoLayerPath{};
    std::optional<yt::PoolType> poolType;
};

bool isValid(const YtWorkerConfig& config);


struct WikiWorkerConfig {
    pgpool3::Pool* pool{nullptr};

    size_t concurrency{0};
    maps::wiki::revision::DBID commitId{0};
};

bool isValid(const WikiWorkerConfig& config);

} // namespace maps::mrc::eye
