#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/config/include/config.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/frame.h>

#include <util/ysaveload.h>

#include <string>

namespace maps::mrc::eye {

class FrameLoader {

public:
    FrameLoader() = default;

    FrameLoader(const std::string& mrcMdsHost, const std::string& mrcMdsNamespace, int mrcMdsPort);

    static FrameLoader fromConfig(const common::Config& config);

    cv::Mat load(const db::eye::Frame& frame) const;

    cv::Mat load(const db::eye::UrlContext& urlContext, const common::ImageOrientation& orientation) const;

    std::string loadRaw(const db::eye::UrlContext& urlContext) const;
private:
    std::string loadMrcRaw(const db::eye::MrcUrlContext& urlContext) const;

    std::string loadPanoramaRaw(const db::eye::PanoramaUrlContext& urlContext) const;

    TString mrcMdsPrefix_;

public:
    Y_SAVELOAD_DEFINE(mrcMdsPrefix_);
};

} // namespace maps::mrc::eye
