#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/metadata_gateway.h>

#include <maps/libs/chrono/include/time_point.h>

#include <pqxx/pqxx>

#include <optional>
#include <string>

namespace maps::mrc::eye {

class MetadataManagerBase
{
public:
    MetadataManagerBase(std::string name, pqxx::transaction_base& txn);
    virtual ~MetadataManagerBase() {}

    const std::string& name() const;

    void updateTime();

    std::optional<chrono::TimePoint> getTime();

protected:
    std::string fullKey(const std::string& key) const;

    db::MetadataGateway& gateway() { return gateway_; }

private:
    std::string timeKey() const;

    std::string name_;
    db::MetadataGateway gateway_;
};


class MetadataManager
    : public MetadataManagerBase
{

public:
    MetadataManager(std::string name, pqxx::transaction_base& txn);

    void updateTxnId(db::TId txnId);

    db::TId getTxnId();

private:
    std::string txnIdKey() const;
};

} // namespace maps::mrc::eye
