#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/config/include/config.h>

#include <library/cpp/yson/node/node.h>

#include <optional>

namespace maps::mrc::eye {

class SecureConfig {
public:
    SecureConfig(const SecureConfig&) = delete;
    SecureConfig(SecureConfig&&) = delete;
    SecureConfig& operator=(const SecureConfig&) = delete;
    SecureConfig& operator=(SecureConfig&&) = delete;

    // Call this method after NYT::Initialize. This way next call to
    // SecureConfig::instance either use the provided MRC config or will load
    // it from YT secure vault.
    static void initialize(std::optional<common::Config> config);

    static bool isInitialized();

    static const SecureConfig& instance();

    operator NYT::TNode() const;

    const common::Config& mrcConfig() const;

private:
    SecureConfig(common::Config mrcConfig) : mrcConfig_{mrcConfig} { }

    common::Config mrcConfig_;
};

} // namespace maps::mrc::eye
