#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/frame.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/url_context.h>

#include <maps/libs/mds-client/include/yandex/maps/mds/mds.h>

#include <string>

namespace maps::mrc::eye {

class FrameUrlResolver {
public:
    FrameUrlResolver(
        const http::URL& browserUrl,
        const http::URL& browserProUrl);

    std::string preview(
        const db::eye::Frame& frame,
        db::FeaturePrivacy privacy) const;

    std::string image(
        const db::eye::Frame& frame,
        db::FeaturePrivacy privacy) const;

    std::string image(
        const db::eye::Frame& frame,
        const common::ImageOrientation& orientation,
        db::FeaturePrivacy privacy) const;

private:
    http::URL getBrowserUrl(db::FeaturePrivacy privacy) const;

    std::string makeMrcPreviewUrl(
        const db::eye::MrcUrlContext& urlContext,
        db::FeaturePrivacy privacy) const;

    std::string makeMrcUrl(
        const db::eye::MrcUrlContext& urlContext,
        const common::ImageOrientation& orientation,
        db::FeaturePrivacy privacy) const;

    std::string makePanoramaPreviewUrl(
        const db::eye::PanoramaUrlContext& urlContext) const;

    std::string makePanoramaUrl(
        const db::eye::PanoramaUrlContext& urlContext,
        const std::optional<common::Size>& size = std::nullopt) const;

    const http::URL browserUrl_;
    const http::URL browserProUrl_;
};

} // namespace maps::mrc::eye
