#pragma once

#include <vector>

namespace maps::mrc::eye {

template<typename Map>
auto collectKeys(const Map& map)
{
    std::vector<typename Map::key_type> keys;
    keys.reserve(map.size());

    for (const auto& [key, _]: map) {
        keys.emplace_back(key);
    }

    return keys;
}

template<typename Map>
auto collectValues(const Map& map)
{
    std::vector<typename Map::mapped_type> values;
    values.reserve(map.size());

    for (const auto& [_, value]: map) {
        values.emplace_back(value);
    }

    return values;
}



} // namespace maps::mrc::eye
