#include <library/cpp/testing/gtest/gtest.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/common/include/load.h>
#include <maps/wikimap/mapspro/services/mrc/libs/config/include/config.h>
#include <maps/wikimap/mapspro/services/mrc/libs/unittest/include/yandex/maps/mrc/unittest/local_server.h>
#include <maps/wikimap/mapspro/services/mrc/libs/unittest/include/yandex/maps/mrc/unittest/unittest_config.h>

namespace maps::mrc::eye::tests {

class MdsStubFixture: public unittest::MdsStubFixture {
public:
    MdsStubFixture(xml3::Doc& configDoc)
        : unittest::MdsStubFixture(configDoc, GetWorkPath() + "/storage")
    {}
};

inline auto& playground() {
    static unittest::WithUnittestConfig<MdsStubFixture> global;
    return global;
}

struct Fixture: public testing::Test {
    const auto& config() const { return playground().config(); }
};

TEST_F(Fixture, bad_size)
{
    db::eye::Frame frame {
        1,
        common::ImageOrientation::fromExif(3),
        db::eye::MrcUrlContext{1, unittest::MDS_GROUP_ID, "M1_CW0"},
        {1280, 720},
        chrono::TimePoint()
    };

    const auto loader = FrameLoader::fromConfig(config());
    EXPECT_THROW(loader.load(frame), maps::LogicError);
}


TEST_F(Fixture, mrc)
{
    db::eye::Frame frame {
        1,
        common::ImageOrientation::fromExif(3),
        db::eye::MrcUrlContext{1, unittest::MDS_GROUP_ID, "M1_CW0"},
        {500, 500},
        chrono::TimePoint()
    };

    const auto loader = FrameLoader::fromConfig(config());
    EXPECT_NO_THROW(loader.load(frame));
}

} // namespace maps::mrc::eye::tests
