#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_house_number/include/detect_house_number.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_house_number/include/worker.h>

namespace maps::mrc::eye {

namespace {

constexpr double CAR_INTERSECTION_RATIO = 0.5;

} // namespace

db::eye::Recognition MakeHouserNumberRecognition::operator()(
        const db::eye::Frame& frame,
        const house_number_sign_detector::HouseNumberSigns& detections,
        const cv::Mat& mask) const
{
    db::eye::DetectedHouseNumbers result;

    for (const auto& detection:  detections) {
        const common::ImageBox box(detection.box);

        ASSERT(not mask.empty());

        if (common::getIntersectionRatio(box, mask) < CAR_INTERSECTION_RATIO) {
            result.push_back({
                common::revertByImageOrientation(box, frame.originalSize(), frame.orientation()),
                detection.confidence,
                detection.number
            });
        }
    }

    return {
        frame.id(),
        frame.orientation(),
        db::eye::RecognitionType::DetectHouseNumber,
        db::eye::RecognitionSource::Model,
        DetectHouseNumber::VERSION,
        result
    };
}

REGISTER_MAPPER(DetectHouseNumberWorker);

} // namespace maps::mrc::eye
