#pragma once

#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_house_number/include/config.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_object/include/worker.h>

#include <maps/wikimap/mapspro/services/mrc/libs/carsegm/include/carsegm.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/frame.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition.h>
#include <maps/wikimap/mapspro/services/mrc/libs/house_number_sign_detector/include/house_number_sign_detector.h>

#include <opencv2/opencv.hpp>

namespace maps::mrc::eye {

struct HouseNumberDetector: public house_number_sign_detector::FasterRCNNDetector {
    inline auto detect(const cv::Mat& image) const
    {
        return FasterRCNNDetector::detect(image, house_number_sign_detector::RecognizeNumber::Yes);
    }
};

struct MakeHouserNumberRecognition {
    db::eye::Recognition operator()(
            const db::eye::Frame& frame,
            const house_number_sign_detector::HouseNumberSigns& detections,
            const cv::Mat& mask) const;
};

using DetectHouseNumberWorker = DetectObjectWithFilteringWorker<
    HouseNumberDetector,
    carsegm::CarSegmentator,
    MakeHouserNumberRecognition
>;

template<class Worker>
db::eye::Recognitions detectHouseNumberImpl(
        const DetectHouseNumberConfig& config,
        const db::eye::Frames& frames)
{
   return simpleDetectObject<Worker>(config, "eye::detect_house_number", frames);
}

inline db::eye::Recognitions detectHouseNumber(
        const DetectHouseNumberConfig& config,
        const db::eye::Frames& frames)
{
   return detectHouseNumberImpl<DetectHouseNumberWorker>(config, frames);
}

} // namespace maps::mrc::eye
