#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_object/include/test_util.h>

#include <algorithm>

namespace maps::mrc::eye::tests {

db::eye::Recognition getRecognition(
        const db::eye::Recognitions& recognitions,
        const db::eye::Frame& frame)
{
    const auto it = std::find_if(
        recognitions.begin(), recognitions.end(),
        [&](const auto& recognition) {
            return recognition.frameId() == frame.id()
                and recognition.orientation() == frame.orientation();
        }
    );

    ASSERT(it != recognitions.end());
    return *it;
}

} // namespace maps::mrc::eye::tests