#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_object/include/worker.h>

#include <util/generic/size_literals.h>

namespace maps::mrc::eye {

NYT::TNode makeSimpleDetectObjectSpec(
        std::string_view title,
        bool useGpu,
        size_t concurrency,
        const std::optional<std::string>& portoLayerPath,
        std::optional<yt::PoolType> poolType)
{
    NYT::TNode spec;

    if (useGpu) {
        spec = yt::baseGpuOperationSpec(title, poolType)
            ("mapper", yt::baseWorkerSpec(portoLayerPath)
                ("memory_limit", 4_GB)
                ("gpu_limit", 1)
            );
    } else {
        spec = yt::baseCpuOperationSpec(title, poolType)
            ("mapper", yt::baseWorkerSpec(portoLayerPath)
                ("cpu_limit", 1)
                ("memory_limit", 8_GB)
                ("memory_reserve_factor", 0.6)
            );
    }

    spec("resource_limits", yt::baseWorkerSpec(portoLayerPath)
            ("user_slots", concurrency)
    );

    spec("max_failed_job_count", 30);

    return spec;
}

} // namespace maps::mrc::eye
