#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/frame.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition.h>

#include <maps/libs/common/include/exception.h>

#include <opencv2/opencv.hpp>

#include <deque>
#include <utility>

namespace maps::mrc::eye::tests {

template<class Detection, class Detections = std::vector<Detection>>
class TestDetector {
public:
    TestDetector(std::deque<Detections> queue): queue_(std::move(queue)) {}

    Detections detect(const cv::Mat&) {
        ASSERT(not queue_.empty());

        auto detections = queue_.front();
        queue_.pop_front();

        return detections;
    }

private:
    std::deque<Detections> queue_;
};

class TestSegmentator {
public:
    TestSegmentator(std::deque<cv::Mat> init): queue_(std::move(init)) {}

    cv::Mat segment(const cv::Mat&) {
        ASSERT(not queue_.empty());

        auto mask = queue_.front();
        queue_.pop_front();

        return mask;
    }

private:
    std::deque<cv::Mat> queue_;
};

db::eye::Recognition getRecognition(
        const db::eye::Recognitions& recognitions,
        const db::eye::Frame& frame);

} // namespace maps:mrc::eye::tests
