#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_object/tests/common.h>

namespace maps::mrc::eye::tests {

std::deque<traffic_light_detector::DetectedTrafficLights> detectionList()
{
    traffic_light_detector::DetectedTrafficLights first {
        {cv::Rect{100, 100, 100,100}, 1.0},
    };

    traffic_light_detector::DetectedTrafficLights second {};

    traffic_light_detector::DetectedTrafficLights third {
        {cv::Rect{100, 100, 50, 50}, 1.0},
        {cv::Rect{400, 100, 100, 100}, 1.0},
        {cv::Rect{600, 100, 100, 100}, 1.0},
    };

    return {first, second, third};
}

std::deque<cv::Mat> maskList()
{
    cv::Mat first = cv::Mat::zeros(1920, 1080, CV_64F);

    cv::Mat third = cv::Mat::zeros(1080, 1920, CV_64F);
    third(cv::Rect{300, 0, 300, 300}) = cv::Mat::ones(300, 300, CV_64F);

    return {first, /* second skiped */ third};
}

db::eye::Recognition MakeRecognitionWithFiltering::operator()(
        const db::eye::Frame& frame,
        const traffic_light_detector::DetectedTrafficLights& detections,
        const cv::Mat& mask)
{
    db::eye::DetectedTrafficLights trafficLights;

    for (const auto& [cvBox, confidence]:  detections) {
        const common::ImageBox box(cvBox);

        if (common::getIntersectionRatio(box, mask) < 0.5) {
            trafficLights.push_back({
                common::revertByImageOrientation(box, frame.originalSize(), frame.orientation()),
                confidence
            });
        }
    }

    return {
        frame.id(),
        frame.orientation(),
        db::eye::RecognitionType::DetectTrafficLight,
        db::eye::RecognitionSource::Model,
        version,
        trafficLights
    };
}

REGISTER_MAPPER(ExampleWorker);

bool hasTrafficLight(
        const db::eye::DetectedTrafficLights& trafficLights,
        const common::ImageBox& box)
{
    for (size_t i = 0; i < trafficLights.size(); ++i)
    {
        const auto trafficLight = trafficLights[i];
        if (trafficLight.box == box) {
            return true;
        }
    }

    return false;
}

} // namespace maps::mrc::eye::tests
