#pragma once

#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_object/include/detect_object.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_object/include/worker.h>

#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_object/include/test_util.h>
#include <maps/wikimap/mapspro/services/mrc/libs/traffic_light_detector/include/traffic_light_faster_rcnn.h>

namespace maps::mrc::eye::tests {

bool hasTrafficLight(
        const db::eye::DetectedTrafficLights& trafficLights,
        const common::ImageBox& box);

std::deque<traffic_light_detector::DetectedTrafficLights> detectionList();

std::deque<cv::Mat> maskList();

// use traffic light as simple object
struct ExampleDetector: public TestDetector<traffic_light_detector::DetectedTrafficLight> {
    ExampleDetector(): TestDetector(detectionList()) {}
};

struct ExampleSegmentator: public TestSegmentator {
    ExampleSegmentator(): TestSegmentator(maskList()) {}
};

constexpr int16_t version = 0;

struct MakeRecognitionWithFiltering {
    db::eye::Recognition operator()(
            const db::eye::Frame& frame,
            const traffic_light_detector::DetectedTrafficLights& detections,
            const cv::Mat& mask);
};

using ExampleWorker = DetectObjectWithFilteringWorker<
    ExampleDetector,
    ExampleSegmentator,
    MakeRecognitionWithFiltering
>;

inline auto exampleDetectObject(const SimpleDetectObjectConfig& config, const db::eye::Frames& frames)
{
    return simpleDetectObject<ExampleWorker>(config, "test", frames);
}

inline MetadataManager exampleMetadata(pqxx::transaction_base& txn) { return {"test", txn}; }

using ExampleDetectObject = SimpleDetectObject<
    &exampleDetectObject,
    &exampleMetadata,
    db::eye::RecognitionType::DetectTrafficLight,
    version,
    common::LockId::EyeDetectTrafficLight>;

} // namespace maps::mrc::eye::tests
