#include <maps/wikimap/mapspro/services/mrc/libs/unittest/include/yandex/maps/mrc/unittest/database_fixture.h>
#include <maps/wikimap/mapspro/services/mrc/libs/unittest/include/yandex/maps/mrc/unittest/unittest_config.h>

#include <maps/wikimap/mapspro/services/mrc/eye/lib/unit_test/include/mds.h>

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/frame.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition.h>

#include <library/cpp/testing/unittest/registar.h>

#include <initializer_list>

namespace maps::mrc::eye::tests {

inline auto& playground() {
    static unittest::WithUnittestConfig<unittest::DatabaseFixture, MdsStubFixture> global;
    return global;
}

struct Fixture: public NUnitTest::TBaseFixture {
    Fixture();

    ~Fixture();

    const auto& config() const { return playground().config(); }

    auto& pool() const { return playground().pool(); }

    auto newTxn() const { return pool().masterWriteableTransaction(); }

    db::TId frameIdAt(size_t index) const;
    db::TIds frameIdsAt(std::initializer_list<size_t> indexes) const;

    db::eye::Recognition recognitionFor(const db::eye::Frame& frame, int16_t version) const;

    db::eye::Devices devices;
    db::eye::Frames frames;
};

} // namespace maps::mrc::eye::tests

