#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_object/tests/common.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_object/tests/fixture.h>

#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_object/include/test_util.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_object/include/worker.h>

#include <library/cpp/testing/unittest/registar.h>
#include <mapreduce/yt/tests/yt_unittest_lib/yt_unittest_lib.h>

namespace maps::mrc::eye::tests {

Y_UNIT_TEST_SUITE_F(worker, Fixture)
{

Y_UNIT_TEST(simple_detect_object_with_filtering)
{
    const auto loader = FrameLoader::fromConfig(config());
    const auto yt = NYT::NTesting::CreateTestClient();

    // keep order of frames
    SimpleDetectObjectConfig workerConfig;
    workerConfig.yt.client = yt.Get();
    workerConfig.yt.frameLoader = &loader;
    workerConfig.yt.rootPath = "//tmp/worker/run";
    workerConfig.yt.partitionSize = 10; // all frames on one worker
    workerConfig.yt.concurrency = 1;
    workerConfig.yt.useGpu = false;

    const common::ImageOrientation identical{};
    const common::ImageOrientation onLeftSide{common::Rotation::CW_90};

    const auto recognitions = simpleDetectObject<ExampleWorker>(workerConfig, "test", {frames[1], frames[2], frames[3]});
    UNIT_ASSERT_EQUAL(recognitions.size(), 3u);

    const auto list = detectionList();

    {
        const auto frame = frames.at(1);
        const auto recognition = recognitions.at(0);
        const auto detections = list.at(0);

        UNIT_ASSERT_EQUAL(recognition.orientation(), frame.orientation());
        UNIT_ASSERT_EQUAL(recognition.type(), db::eye::RecognitionType::DetectTrafficLight);
        UNIT_ASSERT_EQUAL(recognition.source(), db::eye::RecognitionSource::Model);

        const auto trafficLights = recognition.value<db::eye::DetectedTrafficLights>();

        UNIT_ASSERT_EQUAL(trafficLights.size(), 1u);

        const common::ImageBox box = common::revertByImageOrientation(
            detections.at(0).box,
            frame.originalSize(),
            frame.orientation()
        );

        UNIT_ASSERT(hasTrafficLight(trafficLights, box));
    }

    {
        const auto frame = frames.at(2);
        const auto recognition = recognitions.at(1);

        UNIT_ASSERT_EQUAL(recognition.orientation(), frame.orientation());
        UNIT_ASSERT_EQUAL(recognition.type(), db::eye::RecognitionType::DetectTrafficLight);
        UNIT_ASSERT_EQUAL(recognition.source(), db::eye::RecognitionSource::Model);

        const auto trafficLights = recognition.value<db::eye::DetectedTrafficLights>();

        UNIT_ASSERT_EQUAL(trafficLights.size(), 0u);
    }

    {
        const auto frame = frames.at(3);
        const auto recognition = recognitions.at(2);
        const auto detections = list.at(2);

        UNIT_ASSERT_EQUAL(recognition.orientation(), frame.orientation());
        UNIT_ASSERT_EQUAL(recognition.type(), db::eye::RecognitionType::DetectTrafficLight);
        UNIT_ASSERT_EQUAL(recognition.source(), db::eye::RecognitionSource::Model);

        const auto trafficLights = recognition.value<db::eye::DetectedTrafficLights>();

        UNIT_ASSERT_EQUAL(trafficLights.size(), 2u);
        {
            const common::ImageBox box = common::revertByImageOrientation(
                detections.at(0).box,
                frame.originalSize(),
                frame.orientation()
            );

            UNIT_ASSERT(hasTrafficLight(trafficLights, box));
        }

        // filtering  one box

        {
            const common::ImageBox box = common::revertByImageOrientation(
                detections.at(2).box,
                frame.originalSize(),
                frame.orientation()
            );

            UNIT_ASSERT(hasTrafficLight(trafficLights, box));
        }
    }
}

} // Y_UNIT_TEST_SUITE

} // namespace maps::mrc::eye::tests
