#pragma once

#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_panel/include/config.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_panel/include/worker.h>

#include <maps/wikimap/mapspro/services/mrc/eye/lib/common/include/base_worker.h>

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/frame.h>

#include <maps/libs/pgpool3utils/include/yandex/maps/pgpool3utils/pg_advisory_mutex.h>

#include <pqxx/pqxx>

#include <string>

namespace maps::mrc::eye {

class DetectPanel
    : public BaseMrcWorkerWithConfig<
        DetectPanelConfig,
        common::LockId::EyeDetectPanel>
{
public:
    static constexpr int16_t version = 0;

    using BaseMrcWorkerWithConfig::BaseMrcWorkerWithConfig;

    void processBatch(const db::TIds& frameIds) override;

    bool processBatchInLoopMode(size_t size) override;

private:
    Partitions load(pqxx::transaction_base& txn, const db::TIdSet& frameIds);

    size_t save(
        pqxx::transaction_base& txn,
        const db::TIdSet& toSaveIds,
        const DetectedPanels& detections);
};

} // namespace maps::mrc::eye
