#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_panel/tests/fixture.h>

#include <maps/wikimap/mapspro/services/mrc/eye/lib/common/include/url.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_panel/include/worker.h>

#include <library/cpp/testing/unittest/registar.h>
#include <mapreduce/yt/tests/yt_unittest_lib/yt_unittest_lib.h>

#include <algorithm>

namespace maps::mrc::eye::tests {

Y_UNIT_TEST_SUITE_F(worker, Fixture)
{

Y_UNIT_TEST(partition_test_size)
{
    const mds::Mds mds = config().makeMdsClient();
    const size_t margin = 2;

    const std::vector<db::eye::Frames> sequences {
        {frames[0], frames[1], frames[2], frames[3], frames[4], frames[5]},
        {frames[6], frames[7], frames[8], frames[9]},
    };

    {
        const size_t size = 4;
        const size_t margin = 2;

        const auto partitions = makePartitions(sequences, size, margin);
        UNIT_ASSERT_EQUAL(partitions.frames.size(), 10u);
        UNIT_ASSERT_EQUAL(partitions.partitionNumber, 2u);
    }

    {
        const size_t size = 3;

        const auto partitions = makePartitions(sequences, size, margin);
        UNIT_ASSERT_EQUAL(partitions.frames.size(), 10u);
        UNIT_ASSERT_EQUAL(partitions.partitionNumber, 3u);
    }
}

Y_UNIT_TEST(partition_test_margin)
{
    const mds::Mds mds = config().makeMdsClient();
    const size_t margin = 2;
    const size_t size = 3;

    const std::vector<db::eye::Frames> sequences {
        {frames[0], frames[1], frames[2], frames[3], frames[4]},
        {frames[6], frames[7]},
    };

    const auto partitions = makePartitions(sequences, size, margin);
    UNIT_ASSERT_EQUAL(partitions.frames.size(), 5u);
    UNIT_ASSERT_EQUAL(partitions.partitionNumber, 1u);
}

Y_UNIT_TEST(run_worker)
{
    auto yt = NYT::NTesting::CreateTestClient();
    const auto loader = FrameLoader::fromConfig(config());

    DetectPanelConfig config;
    config.yt.client = yt.Get();
    config.yt.concurrency = 1;
    config.yt.frameLoader = &loader;
    config.yt.rootPath = "//tmp/worker/run_worker";
    config.yt.partitionSize = 3;
    config.mrc.commit = true;
    config.margin = 2;

    const std::vector<db::eye::Frames> sequences {
        {frames[0], frames[1], frames[2], frames[3], frames[4], frames[5]},
    };

    const auto partitions = makePartitions(sequences, config.yt.partitionSize, config.margin);
    const auto detections = detectPanel(config, partitions);

    UNIT_ASSERT_EQUAL(detections.size(), 6u);

    UNIT_ASSERT(
        std::all_of(
            detections.begin(), detections.end(),
            [&](const auto& detection) {
                // As detector see frame, orientation = 1
                constexpr size_t width = 284;

                const common::ImageBox box = detection.restBox;

                return box.minX() == 0 and box.minY() == 0
                    and box.maxX() == width and box.maxY() >= 120;
            }
        )
    );
}

Y_UNIT_TEST(run_worker_no_default_orientation)
{
    const auto loader = FrameLoader::fromConfig(config());
    const auto yt = NYT::NTesting::CreateTestClient();

    DetectPanelConfig config;
    config.yt.client = yt.Get();
    config.yt.concurrency = 1;
    config.yt.frameLoader = &loader;
    config.yt.partitionSize = 3;
    config.yt.rootPath = "//tmp/worker/run_worker_no_default_orientation";
    config.mrc.commit = true;
    config.margin = 2;

    const std::vector<db::eye::Frames> sequences {
        {frames[6], frames[7], frames[8], frames[9]},
    };

    const auto partitions = makePartitions(sequences, config.yt.partitionSize, config.margin);
    const auto detections = detectPanel(config, partitions);

    UNIT_ASSERT_EQUAL(detections.size(), 4u);

    UNIT_ASSERT(
        std::all_of(
            detections.begin(), detections.end(),
            [&](const auto& detection) {

                // As detector see frame, orientation = 3
                constexpr size_t width = 284;
                constexpr size_t height = 160;

                const common::ImageBox box = detection.restBox;

                return box.minX() == 0 and box.minY() <= 40
                    and box.maxX() == width and box.maxY() == height;
            }
        )
    );
}

Y_UNIT_TEST(run_worker_changing_size)
{
    const auto loader = FrameLoader::fromConfig(config());
    const auto yt = NYT::NTesting::CreateTestClient();

    DetectPanelConfig config;
    config.yt.client = yt.Get();
    config.yt.concurrency = 1;
    config.yt.frameLoader = &loader;
    config.yt.partitionSize = 10;
    config.yt.rootPath = "//tmp/worker/run_worker_changing_size";
    config.mrc.commit = true;
    config.margin = 2;

    const std::vector<db::eye::Frames> sequences {
        {frames[6], frames[7], frames[8], frames[9]},
        {frames[10], frames[11], frames[12], frames[13]},
    };

    const auto partitions = makePartitions(sequences, config.yt.partitionSize, config.margin);
    const auto detections = detectPanel(config, partitions);

    UNIT_ASSERT_EQUAL(detections.size(), 8u);

    const auto middle = detections.begin() + 4;

    UNIT_ASSERT(
        std::all_of(
            detections.begin(), middle,
            [&](const auto& detection) {
                // As detector see frame, orientation = 3
                constexpr size_t width = 284;
                constexpr size_t height = 160;

                const common::ImageBox box = detection.restBox;

                return box.minX() == 0 and box.minY() <= 40
                    and box.maxX() == width and box.maxY() == height;
            }
        )
    );

    UNIT_ASSERT(
        std::all_of(
            middle, detections.end(),
            [&](const auto& detection) {
                const common::ImageBox box = detection.restBox;

                // As detector see frame, orientation = 6
                constexpr size_t width = 120;
                constexpr size_t height = 160;

                return box.minX() <= 60 and box.minY() == 0
                    and box.maxX() == height and box.maxY() == width;
            }
        )
    );
}

} // Y_UNIT_TEST_SUITE

} // namespace maps::mrc::eye::tests
