#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/frame_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition_gateway.h>

namespace maps::mrc::eye {

// Входные данные для детектора дорожной разметки
//  * frameById - отображение frameId во frame
//  * panelByFrameId - отображение frameId в
//    в recognition типа DetectPanel
struct DetectRoadMarkingInputData {
    db::IdTo<db::eye::Frame> frameById;
    db::IdTo<db::eye::Recognition> panelByFrameId;
};

// Входной батч для детектора дорожной разметки
// * beginFrameTxnId, endFrameTxnId - интервал по txn id
//   в очереди frame'ов, из которого были загружены данные.
//   Если в этой очереди нет новых данных, то
//   beginFrameTxnId == endFrameTxnId
//
// * beginPanelTxnId, endPanelTxnId - интервал по txn id
//   в очереди recognition'ов, из которого были загружены данные.
//   Если в этой очереди нет новых данных, то
//   beginPanelTxnId == endPanelTxnId
//
// * data - данные, которые были прочитаны из обеих очередей
struct DetectRoadMarkingBatch {
    db::TId beginFrameTxnId;
    db::TId endFrameTxnId;

    db::TId beginPanelTxnId;
    db::TId endPanelTxnId;

    DetectRoadMarkingInputData data;
};

// Загружает входные данные для детектора дорожной разметки
//
// * frameIds - id frame'ов, данные для которых нужно загрузить
//   При этом данные загружаются только для неудаленных frame'ов
DetectRoadMarkingInputData loadDetectRoadMarkingInputData(
    pqxx::transaction_base& txn,
    const db::TIds& frameIds);

// Загружает входной батч для детектора дорожной разметки
//
// Загрузка батча происходит сразу из двух очередей
//  * beginFrameTxnId - txn id начала очереди frame'ов
//  * beginPanelTxnId - txn id начала очереди recognition'ов
//
//  * limit - максимальное число элементов, загружаемых из базы.
//    При этом из каждой из очередей может быть загружено больше
//    элементов, если сразу много элементов имеют одинаковый txn id
DetectRoadMarkingBatch loadDetectRoadMarkingBatch(
    pqxx::transaction_base& txn,
    db::TId beginFrameTxnId,
    db::TId beginPanelTxnId,
    size_t limit);

} // namespace maps::mrc::eye
