#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_object/include/detect_object.h>

namespace maps::mrc::eye {

namespace {

db::TIdSet framesWithRecognitions(
    pqxx::transaction_base& txn,
    const db::IdTo<db::eye::Frame>& frameById)
{
    db::TIds frameIds;
    for (const auto& [frameId, _] : frameById) {
        frameIds.push_back(frameId);
    }

    db::TIds recognizedFrameIds = db::eye::FrameGateway(txn).loadIds(
        db::eye::table::Frame::id.in(frameIds) &&
        db::eye::table::Frame::id == db::eye::table::Recognition::frameId &&
        db::eye::table::Frame::orientation == db::eye::table::Recognition::orientation &&
        db::eye::table::Recognition::type == db::eye::RecognitionType::DetectRoadMarking
    );

    return {recognizedFrameIds.begin(), recognizedFrameIds.end()};
}

} // namespace

db::IdTo<db::eye::Frame> removeRecognizedFrames(
    pqxx::transaction_base& txn,
    db::IdTo<db::eye::Frame> frameById)
{
    db::TIdSet recognizedFrameIds = framesWithRecognitions(txn, frameById);

    std::erase_if(
        frameById,
        [&](const auto& item) {
            const auto& [frameId, frame] = item;
            return recognizedFrameIds.count(frameId) != 0;
        }
    );

    return frameById;
}

} // namespace maps::mrc::eye
