#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_road_marking/impl/metadata.h>

#include <maps/libs/log8/include/log8.h>

namespace maps::mrc::eye {

void DetectRoadMarkingMetadataManager::updateFrameTxnId(db::TId txnId) {
    const auto key = frameTxnIdKey();

    INFO() << "Update metadata " << key << " " << txnId;
    gateway().upsertByKey(key, std::to_string(txnId));
}

void DetectRoadMarkingMetadataManager::updatePanelTxnId(db::TId txnId) {
    const auto key = panelTxnIdKey();

    INFO() << "Update metadata " << key << " " << txnId;
    gateway().upsertByKey(key, std::to_string(txnId));
}

db::TId DetectRoadMarkingMetadataManager::getFrameTxnId() {
    return gateway().tryLoadByKey<db::TId>(frameTxnIdKey(), 0);
}

db::TId DetectRoadMarkingMetadataManager::getPanelTxnId() {
    return gateway().tryLoadByKey<db::TId>(panelTxnIdKey(), 0);
}

// Идентификатор начала очереди frame'ов
std::string DetectRoadMarkingMetadataManager::frameTxnIdKey() const {
    return fullKey("frame_txn_id");
}

// Идентификатора начала очереди recognition'ов
std::string DetectRoadMarkingMetadataManager::panelTxnIdKey() const {
    return fullKey("panel_txn_id");
}

} // namespace maps::mrc::eye
