#pragma once

#include <maps/wikimap/mapspro/services/mrc/eye/lib/common/include/metadata.h>

namespace maps::mrc::eye {

// Входные данные для детектора читаются из двух очередей
// Соответсвенно в базе данных хранятся три записи:
//  * frame_txn_id - такой txn id, что все frame'ы
//    с меньшим txn_id уже были обработаны детектором
//  * panel_txn_id - такой txn id, что все recognition'ы
//    с меньшим txn_id уже были обработаны детектором
//  * time - время последнего удачного запуска детектора
class DetectRoadMarkingMetadataManager : public MetadataManagerBase {
public:
    DetectRoadMarkingMetadataManager(pqxx::transaction_base& txn)
        : MetadataManagerBase("detect_road_marking", txn)
    {}

    void updateFrameTxnId(db::TId txnId);
    void updatePanelTxnId(db::TId txnId);

    db::TId getFrameTxnId();
    db::TId getPanelTxnId();

private:
    std::string frameTxnIdKey() const;
    std::string panelTxnIdKey() const;
};

} // namespace maps::mrc::eye
