#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_road_marking/impl/serialize.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_road_marking/impl/strings.h>
#include <maps/wikimap/mapspro/services/mrc/libs/yt/include/serialization.h>

namespace maps::mrc::eye {

void writeFrames(
    NYT::ITransactionPtr ytTxn,
    const TString& input,
    const db::IdTo<db::eye::Frame>& frameById,
    const db::IdTo<db::eye::Recognition>& panelByFrameId)
{
    NYT::TTableWriterPtr<NYT::TNode> writer
        = ytTxn->CreateTableWriter<NYT::TNode>(input);

    for (const auto& [frameId, frame] : frameById) {
        auto it = panelByFrameId.find(frameId);
        if (panelByFrameId.end() == it) {
            // еще нет панели автомобиля
            continue;
        }

        const db::eye::Recognition& panel = it->second;

        NYT::TNode node;
        node[FRAME_COLUMN] = yt::serialize<db::eye::Frame>(frame);
        node[PANEL_COLUMN] = yt::serialize<db::eye::Recognition>(panel);

        writer->AddRow(node);
    }

    writer->Finish();
}

} // namespace maps::mrc::eye
