#pragma once

#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_object/include/config.h>

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/frame_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition_gateway.h>

namespace maps::mrc::eye {

// Записывает данные о frame'ах и recognition'ах в YT таблицу.
//
// При этом в таблицу записываются только те frame'ы, у которых
// есть соответствующие recognition'ы панелей машин.
//
// Выходная таблица имеет две колонки:
//  1) 'frame' - содержит всю информацию о frame'е
//  2) 'panel' - содержит всю информацию о recognition'е панели
void writeFrames(
    NYT::ITransactionPtr ytTxn,
    const TString& tablePath,
    const db::IdTo<db::eye::Frame>& frameById,
    const db::IdTo<db::eye::Recognition>& panelByFrameId);

} // namespace maps::mrc::eye
