#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_road_marking/impl/yt_spec.h>

#include <maps/wikimap/mapspro/services/mrc/eye/lib/common/include/id.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_object/include/config.h>

#include <maps/wikimap/mapspro/services/mrc/libs/yt/include/common.h>

#include <util/generic/size_literals.h>

namespace maps::mrc::eye {

namespace {

static const TString WORKER_TITLE = "eye::detect_road_marking";

} // namespace

NYT::TNode makeDetectWorkerSpec(const YtWorkerConfig& config)
{
    NYT::TNode spec;

    if (config.useGpu) {
        spec = yt::baseGpuOperationSpec(WORKER_TITLE, config.poolType)
            ("mapper", yt::baseWorkerSpec(config.portoLayerPath)
                ("memory_limit", 4_GB)
                ("gpu_limit", 1)
            );
    } else {
        spec = yt::baseCpuOperationSpec(WORKER_TITLE, config.poolType)
            ("mapper", yt::baseWorkerSpec(config.portoLayerPath)
                ("cpu_limit", 1)
                ("memory_limit", 8_GB)
                ("memory_reserve_factor", 0.6)
            );
    }

    spec("resource_limits", yt::baseWorkerSpec(config.portoLayerPath)
            ("user_slots", config.concurrency)
    );

    spec("max_failed_job_count", 30);

    return spec;
}

} // namespace maps::mrc::eye
