#pragma once

#include <maps/wikimap/mapspro/services/mrc/eye/lib/common/include/base_worker.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_road_marking/include/config.h>

namespace maps::mrc::eye {

// Детектирует дорожную разметку на изображениях
//
// В качестве входных данных принимает набор frame'ов
// и набор соответсвующих recognition'ов панели машины
// на frame'e.
//
// Если у frame'а еще нет recognition с панелью машины,
// то такой frame не обрабатывается. Он будет обработан
// только после того, как появится новый recognition с
// панелью. Таким образом входные данные читаются независимо
// из двух разных очередей:
//  1) очередь frame'ов
//  2) очередь recognition'ов
//
// Результатом работы являются новые записи в таблице
// recognition с типом db::eye::RecognitionType::DetectRoadMarking
class DetectRoadMarking
    : public BaseMrcWorkerWithConfig<DetectRoadMarkingConfig, common::LockId::EyeDetectRoadMarking>
{
public:
    DetectRoadMarking(const DetectRoadMarkingConfig& config);

    void processBatch(const db::TIds& frameIds) override;

    // Возвращает true, если очередь обработки не пустая
    bool processBatchInLoopMode(size_t batchSize) override;
};

} // namespace maps::mrc::eye
