#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/unittest/include/yandex/maps/mrc/unittest/database_fixture.h>
#include <maps/wikimap/mapspro/services/mrc/libs/unittest/include/yandex/maps/mrc/unittest/unittest_config.h>

#include <maps/wikimap/mapspro/services/mrc/eye/lib/unit_test/include/mds.h>

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/frame.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition.h>

#include <maps/wikimap/mapspro/services/mrc/eye/lib/common/include/secure_config.h>

#include <library/cpp/testing/unittest/registar.h>

namespace maps::mrc::eye::tests {

inline auto& playground() {
    static unittest::WithUnittestConfig<unittest::DatabaseFixture, MdsStubFixture> global;
    return global;
}

struct Fixture: public NUnitTest::TBaseFixture {
    Fixture() {
        // The config content doesn't matter in the tests for now so anyone will fit.
        static std::once_flag onceFlag;
        std::call_once(onceFlag, SecureConfig::initialize, playground().config());
    }

    ~Fixture() { playground().postgres().truncateTables(); }

    const auto& config() const { return playground().config(); }

    auto& pool() const { return playground().pool(); }

    auto newTxn() const { return pool().masterWriteableTransaction(); }

    db::eye::Devices devices;
    db::eye::Frames frames;
    db::eye::Recognitions recognitions;
};

} // namespace maps::mrc::eye::tests
