#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_road_marking/tests/fixture.h>

#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_road_marking/impl/frame.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_road_marking/impl/strings.h>

#include <maps/wikimap/mapspro/services/mrc/eye/lib/location/include/rotation.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/unit_test/include/frame.h>

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition_gateway.h>

#include <library/cpp/testing/unittest/registar.h>
#include <mapreduce/yt/tests/yt_unittest_lib/yt_unittest_lib.h>

#include <maps/wikimap/mapspro/services/mrc/libs/yt/include/io.h>

namespace maps::mrc::eye::tests {

struct FrameFixture : public Fixture {
    FrameFixture() {
        auto txn = newTxn();

        devices = {
            {db::eye::MrcDeviceAttrs{"M1"}},
        };
        db::eye::DeviceGateway(*txn).insertx(devices);

        frames = {
            {devices[0].id(), identical, makeUrlContext(1, "1"), {1200, 800}, time()},
            {devices[0].id(), identical, makeUrlContext(2, "2"), {1200, 800}, time()},
            {devices[0].id(), identical, makeUrlContext(3, "3"), {1200, 800}, time()},
        };
        db::eye::FrameGateway(*txn).insertx(frames);

        recognitions = {
            {
                frames[0].id(),
                frames[0].orientation(),
                db::eye::RecognitionType::DetectRoadMarking,
                db::eye::RecognitionSource::Model,
                0, // version
                db::eye::DetectedRoadMarkings({})
            },
            {
                frames[1].id(),
                common::ImageOrientation(common::Rotation::CW_180),
                db::eye::RecognitionType::DetectRoadMarking,
                db::eye::RecognitionSource::Model,
                0, // version
                db::eye::DetectedRoadMarkings({})
            },
            {
                frames[1].id(),
                frames[1].orientation(),
                db::eye::RecognitionType::DetectRoadMarking,
                db::eye::RecognitionSource::Model,
                0, // version
                db::eye::DetectedRoadMarkings({})
            },
        };
        db::eye::RecognitionGateway(*txn).insertx(recognitions);

        txn->commit();
    }
};

Y_UNIT_TEST_SUITE_F(frame_tests, FrameFixture)
{

Y_UNIT_TEST(base)
{
    auto txn = newTxn();
    db::IdTo<db::eye::Frame> frameById{
        {frames[0].id(), frames[0]},
        {frames[1].id(), frames[1]},
        {frames[2].id(), frames[2]},
    };

    db::IdTo<db::eye::Frame> result = removeRecognizedFrames(*txn, std::move(frameById));

    UNIT_ASSERT_EQUAL(result.size(), 1u);

    UNIT_ASSERT_EQUAL(result.count(frames[2].id()), 1);
}

} // Y_UNIT_TEST_SUITE

} // namespace maps::mrc::eye::tests
