#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_road_marking/tests/fixture.h>

#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_road_marking/impl/metadata.h>

#include <library/cpp/testing/unittest/registar.h>
#include <mapreduce/yt/tests/yt_unittest_lib/yt_unittest_lib.h>

namespace maps::mrc::eye::tests {

Y_UNIT_TEST_SUITE_F(metadata_tests, Fixture)
{

Y_UNIT_TEST(base)
{
    auto txn = newTxn();
    DetectRoadMarkingMetadataManager metadata(*txn);

    UNIT_ASSERT_EQUAL(metadata.getFrameTxnId(), 0u);
    UNIT_ASSERT_EQUAL(metadata.getPanelTxnId(), 0u);
    UNIT_ASSERT_EQUAL(metadata.getTime().has_value(), false);

    db::TId frameTxnId = 1u;
    db::TId panelTxnId = 2u;

    metadata.updateFrameTxnId(frameTxnId);
    metadata.updatePanelTxnId(panelTxnId);

    UNIT_ASSERT_EQUAL(metadata.getFrameTxnId(), frameTxnId);
    UNIT_ASSERT_EQUAL(metadata.getPanelTxnId(), panelTxnId);

    metadata.updateTime();

    UNIT_ASSERT_EQUAL(metadata.getTime().has_value(), true);
}

} // Y_UNIT_TEST_SUITE

} // namespace maps::mrc::eye::tests
