#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_sign/include/detect_sign.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_sign/include/worker.h>

namespace maps::mrc::eye {

namespace {

constexpr double CAR_INTERSECTION_RATIO = 0.5;

} // namespace

db::eye::Recognition MakeSignRecognition::operator()(
        const db::eye::Frame& frame,
        const signdetect::DetectedSigns& detections,
        const cv::Mat& mask) const
{
    db::eye::DetectedSigns signs;
    for (const auto& detection: detections) {
        const common::ImageBox box(detection.box);

        if (common::getIntersectionRatio(box, mask) < CAR_INTERSECTION_RATIO) {
            signs.push_back({
                common::revertByImageOrientation(box, frame.originalSize(), frame.orientation()),
                detection.sign,
                detection.confidence,
                traffic_signs::TemporarySign::Yes == detection.temporarySign,
                detection.temporarySignConfidence
            });
        }
    }

    return {
        frame.id(),
        frame.orientation(),
        db::eye::RecognitionType::DetectSign,
        db::eye::RecognitionSource::Model,
        DetectSign::VERSION,
        signs
    };
}

REGISTER_MAPPER(DetectSignWorker);

} // namespace maps::mrc::eye
