#pragma once

#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_object/include/worker.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_sign/include/config.h>

#include <maps/wikimap/mapspro/services/mrc/libs/carsegm/include/carsegm.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/frame.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition.h>
#include <maps/wikimap/mapspro/services/mrc/libs/signdetect/include/signdetect_complex.h>

#include <opencv2/opencv.hpp>

namespace maps::mrc::eye {

struct MakeSignRecognition {
    db::eye::Recognition operator()(
            const db::eye::Frame& frame,
            const signdetect::DetectedSigns& detections,
            const cv::Mat& mask) const;
};

using DetectSignWorker = DetectObjectWithFilteringWorker<
    signdetect::SignDetectorComplex,
    carsegm::CarSegmentator,
    MakeSignRecognition
>;

template<class Worker>
db::eye::Recognitions detectSignImpl(
        const DetectSignConfig& config,
        const db::eye::Frames& frames)
{
   return simpleDetectObject<Worker>(config, "eye::detect_sign", frames);
}

inline db::eye::Recognitions detectSign(
        const DetectSignConfig& config,
        const db::eye::Frames& frames)
{
   return detectSignImpl<DetectSignWorker>(config, frames);
}

} // namespace maps::mrc::eye
