#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_traffic_light/include/detect_traffic_light.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_traffic_light/include/worker.h>

namespace maps::mrc::eye {

namespace {

constexpr double CAR_INTERSECTION_RATIO = 0.5;

} // namespace

db::eye::Recognition MakeTrafficLightRecognition::operator()(
        const db::eye::Frame& frame,
        const traffic_light_detector::DetectedTrafficLights& detections,
        const cv::Mat& mask) const
{
    db::eye::DetectedTrafficLights trafficLights;
    for (const auto& [cvBox, confidence]:  detections) {
        const common::ImageBox box(cvBox);

        if (common::getIntersectionRatio(box, mask) < CAR_INTERSECTION_RATIO) {
            trafficLights.push_back({
                common::revertByImageOrientation(box, frame.originalSize(), frame.orientation()),
                confidence
            });
        }
    }

    return {
        frame.id(),
        frame.orientation(),
        db::eye::RecognitionType::DetectTrafficLight,
        db::eye::RecognitionSource::Model,
        DetectTrafficLight::VERSION,
        trafficLights
    };
}

REGISTER_MAPPER(DetectTrafficLightWorker);

} // namespace maps::mrc::eye
