#pragma once

#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_object/include/worker.h>
#include <maps/wikimap/mapspro/services/mrc/eye/lib/detect_traffic_light/include/config.h>

#include <maps/wikimap/mapspro/services/mrc/libs/carsegm/include/carsegm.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/frame.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition.h>
#include <maps/wikimap/mapspro/services/mrc/libs/traffic_light_detector/include/traffic_light_faster_rcnn.h>

#include <opencv2/opencv.hpp>

namespace maps::mrc::eye {

struct MakeTrafficLightRecognition {
    db::eye::Recognition operator()(
            const db::eye::Frame& frame,
            const traffic_light_detector::DetectedTrafficLights& detections,
            const cv::Mat& mask) const;
};

using DetectTrafficLightWorker = DetectObjectWithFilteringWorker<
    traffic_light_detector::FasterRCNNDetector,
    carsegm::CarSegmentator,
    MakeTrafficLightRecognition
>;

template<class Worker>
db::eye::Recognitions detectTrafficLightImpl(
        const DetectTrafficLightConfig& config,
        const db::eye::Frames& frames)
{
   return simpleDetectObject<Worker>(config, "eye::detect_traffic_light", frames);
}

inline db::eye::Recognitions detectTrafficLight(
        const DetectTrafficLightConfig& config,
        const db::eye::Frames& frames)
{
   return detectTrafficLightImpl<DetectTrafficLightWorker>(config, frames);
}

} // namespace maps::mrc::eye
